import enum
import numpy as np
from typing import Any, Callable, Tuple, List, Optional

from imgui_bundle import ImVec4Like
from imgui_bundle.imgui import ImTextureID


OpaquePointer = np.uint64
Context = OpaquePointer
UChar = int # a value between 0 and 255
NvgDrawingFunction = Callable[[Context, int, int], Any]

Bounds = Tuple[float, float, float, float]

class Color:
    r: float
    g: float
    b: float
    a: float

    def __init__(self, r:float, g:float, b:float, a:float):
        pass

    def __init__(self, colors_tuple_4_float: tuple):  # noqa: F811
        pass


# ruff: noqa: B008  # Do not perform function call in argument defaults
# ruff: noqa: E741  # Ambiguous variable name: `l`

"""
Python bindings for NanoVG
https://github.com/memononen/nanovg
"""

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:nanovg.h>    ####################
#
# Copyright (c) 2013 Mikko Mononen memon@inside.org
#
# This software is provided 'as-is', without any express or implied
# warranty.  In no event will the authors be held liable for any damages
# arising from the use of this software.
# Permission is granted to anyone to use this software for any purpose,
# including commercial applications, and to alter it and redistribute it
# freely, subject to the following restrictions:
# 1. The origin of this software must not be misrepresented; you must not
#    claim that you wrote the original software. If you use this software
#    in a product, an acknowledgment in the product documentation would be
#    appreciated but is not required.
# 2. Altered source versions must be plainly marked as such, and must not be
#    misrepresented as being the original software.
# 3. This notice may not be removed or altered from any source distribution.
#

# #ifndef NANOVG_H
#

# #ifdef __cplusplus
#
# #endif
#





class Paint:
    # float xform[6];    /* original C++ signature */
    xform: np.ndarray   # ndarray[type=float, size=6]
    # float extent[2];    /* original C++ signature */
    extent: np.ndarray  # ndarray[type=float, size=2]
    # float radius;    /* original C++ signature */
    radius: float
    # float feather;    /* original C++ signature */
    feather: float
    # NVGcolor innerColor;    /* original C++ signature */
    inner_color: Color
    # NVGcolor outerColor;    /* original C++ signature */
    outer_color: Color
    # int image;    /* original C++ signature */
    image: int
    # NVGpaint(float radius = float(), float feather = float(), NVGcolor innerColor = NVGcolor(), NVGcolor outerColor = NVGcolor(), int image = int());    /* original C++ signature */
    def __init__(
        self,
        radius: float = float(),
        feather: float = float(),
        inner_color: Optional[Color] = None,
        outer_color: Optional[Color] = None,
        image: int = int()
        ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                innerColor: Color()
                outerColor: Color()
        """
        pass

class Winding(enum.Enum):
    # NVG_CCW = 1,			    /* original C++ signature */
    ccw = enum.auto() # (= 1)  # Winding for solid shapes
    # NVG_CW = 2,				    /* original C++ signature */
    cw = enum.auto()  # (= 2)  # Winding for holes

class Solidity(enum.Enum):
    # NVG_SOLID = 1,			    /* original C++ signature */
    solid = enum.auto() # (= 1)  # CCW
    # NVG_HOLE = 2,			    /* original C++ signature */
    hole = enum.auto()  # (= 2)  # CW

class LineCap(enum.Enum):
    # NVG_BUTT,    /* original C++ signature */
    butt = enum.auto()   # (= 0)
    # NVG_ROUND,    /* original C++ signature */
    round = enum.auto()  # (= 1)
    # NVG_SQUARE,    /* original C++ signature */
    square = enum.auto() # (= 2)
    # NVG_BEVEL,    /* original C++ signature */
    bevel = enum.auto()  # (= 3)
    # NVG_MITER,    /* original C++ signature */
    # }
    miter = enum.auto()  # (= 4)

class Align(enum.Enum):
    # Horizontal align
    # NVG_ALIGN_LEFT 		= 1<<0,	    /* original C++ signature */
    align_left = enum.auto()     # (= 1<<0)  # Default, align text horizontally to left.
    # NVG_ALIGN_CENTER 	= 1<<1,	    /* original C++ signature */
    align_center = enum.auto()   # (= 1<<1)  # Align text horizontally to center.
    # NVG_ALIGN_RIGHT 	= 1<<2,	    /* original C++ signature */
    align_right = enum.auto()    # (= 1<<2)  # Align text horizontally to right.
    # Vertical align
    # NVG_ALIGN_TOP 		= 1<<3,	    /* original C++ signature */
    align_top = enum.auto()      # (= 1<<3)  # Align text vertically to top.
    # NVG_ALIGN_MIDDLE	= 1<<4,	    /* original C++ signature */
    align_middle = enum.auto()   # (= 1<<4)  # Align text vertically to middle.
    # NVG_ALIGN_BOTTOM	= 1<<5,	    /* original C++ signature */
    align_bottom = enum.auto()   # (= 1<<5)  # Align text vertically to bottom.
    # NVG_ALIGN_BASELINE	= 1<<6,     /* original C++ signature */
    align_baseline = enum.auto() # (= 1<<6)  # Default, align text vertically to baseline.

class BlendFactor(enum.Enum):
    # NVG_ZERO = 1<<0,    /* original C++ signature */
    zero = enum.auto()                # (= 1<<0)
    # NVG_ONE = 1<<1,    /* original C++ signature */
    one = enum.auto()                 # (= 1<<1)
    # NVG_SRC_COLOR = 1<<2,    /* original C++ signature */
    src_color = enum.auto()           # (= 1<<2)
    # NVG_ONE_MINUS_SRC_COLOR = 1<<3,    /* original C++ signature */
    one_minus_src_color = enum.auto() # (= 1<<3)
    # NVG_DST_COLOR = 1<<4,    /* original C++ signature */
    dst_color = enum.auto()           # (= 1<<4)
    # NVG_ONE_MINUS_DST_COLOR = 1<<5,    /* original C++ signature */
    one_minus_dst_color = enum.auto() # (= 1<<5)
    # NVG_SRC_ALPHA = 1<<6,    /* original C++ signature */
    src_alpha = enum.auto()           # (= 1<<6)
    # NVG_ONE_MINUS_SRC_ALPHA = 1<<7,    /* original C++ signature */
    one_minus_src_alpha = enum.auto() # (= 1<<7)
    # NVG_DST_ALPHA = 1<<8,    /* original C++ signature */
    dst_alpha = enum.auto()           # (= 1<<8)
    # NVG_ONE_MINUS_DST_ALPHA = 1<<9,    /* original C++ signature */
    one_minus_dst_alpha = enum.auto() # (= 1<<9)
    # NVG_SRC_ALPHA_SATURATE = 1<<10,    /* original C++ signature */
    # }
    src_alpha_saturate = enum.auto()  # (= 1<<10)

class CompositeOperation(enum.Enum):
    # NVG_SOURCE_OVER,    /* original C++ signature */
    source_over = enum.auto()      # (= 0)
    # NVG_SOURCE_IN,    /* original C++ signature */
    source_in = enum.auto()        # (= 1)
    # NVG_SOURCE_OUT,    /* original C++ signature */
    source_out = enum.auto()       # (= 2)
    # NVG_ATOP,    /* original C++ signature */
    atop = enum.auto()             # (= 3)
    # NVG_DESTINATION_OVER,    /* original C++ signature */
    destination_over = enum.auto() # (= 4)
    # NVG_DESTINATION_IN,    /* original C++ signature */
    destination_in = enum.auto()   # (= 5)
    # NVG_DESTINATION_OUT,    /* original C++ signature */
    destination_out = enum.auto()  # (= 6)
    # NVG_DESTINATION_ATOP,    /* original C++ signature */
    destination_atop = enum.auto() # (= 7)
    # NVG_LIGHTER,    /* original C++ signature */
    lighter = enum.auto()          # (= 8)
    # NVG_COPY,    /* original C++ signature */
    copy = enum.auto()             # (= 9)
    # NVG_XOR,    /* original C++ signature */
    # }
    xor = enum.auto()              # (= 10)

class CompositeOperationState:
    # int srcRGB;    /* original C++ signature */
    src_rgb: int
    # int dstRGB;    /* original C++ signature */
    dst_rgb: int
    # int srcAlpha;    /* original C++ signature */
    src_alpha: int
    # int dstAlpha;    /* original C++ signature */
    dst_alpha: int
    # NVGcompositeOperationState(int srcRGB = int(), int dstRGB = int(), int srcAlpha = int(), int dstAlpha = int());    /* original C++ signature */
    def __init__(
        self,
        src_rgb: int = int(),
        dst_rgb: int = int(),
        src_alpha: int = int(),
        dst_alpha: int = int()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class GlyphPosition:
    # const char* str;    /* original C++ signature */
    str: str     # Position of the glyph in the input string. # (const)
    # float x;    /* original C++ signature */
    x: float     # The x-coordinate of the logical glyph position.
    # float minx,     /* original C++ signature */
    minx: float  # The bounds of the glyph shape.
    # maxx;    /* original C++ signature */
    maxx: float  # The bounds of the glyph shape.
    # NVGglyphPosition(float x = float(), float minx = float(), float maxx = float());    /* original C++ signature */
    def __init__(
        self,
        x: float = float(),
        minx: float = float(),
        maxx: float = float()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class TextRow:
    # const char* start;    /* original C++ signature */
    start: str    # Pointer to the input text where the row starts. # (const)
    # const char* end;    /* original C++ signature */
    end: str      # Pointer to the input text where the row ends (one past the last character). # (const)
    # const char* next;    /* original C++ signature */
    next: str     # Pointer to the beginning of the next row. # (const)
    # float width;    /* original C++ signature */
    width: float  # Logical width of the row.
    # float minx,     /* original C++ signature */
    minx: float   # Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.
    # maxx;    /* original C++ signature */
    maxx: float   # Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.
    # NVGtextRow(float width = float(), float minx = float(), float maxx = float());    /* original C++ signature */
    def __init__(
        self,
        width: float = float(),
        minx: float = float(),
        maxx: float = float()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class ImageFlags(enum.Enum):
    # NVG_IMAGE_GENERATE_MIPMAPS	= 1<<0,         /* original C++ signature */
    image_generate_mipmaps = enum.auto() # (= 1<<0)  # Generate mipmaps during creation of the image.
    # NVG_IMAGE_REPEATX			= 1<<1,		    /* original C++ signature */
    image_repeatx = enum.auto()          # (= 1<<1)  # Repeat image in X direction.
    # NVG_IMAGE_REPEATY			= 1<<2,		    /* original C++ signature */
    image_repeaty = enum.auto()          # (= 1<<2)  # Repeat image in Y direction.
    # NVG_IMAGE_FLIPY				= 1<<3,		    /* original C++ signature */
    image_flipy = enum.auto()            # (= 1<<3)  # Flips (inverses) image in Y direction when rendered.
    # NVG_IMAGE_PREMULTIPLIED		= 1<<4,		    /* original C++ signature */
    image_premultiplied = enum.auto()    # (= 1<<4)  # Image data has premultiplied alpha.
    # NVG_IMAGE_NEAREST			= 1<<5,		    /* original C++ signature */
    image_nearest = enum.auto()          # (= 1<<5)  # Image interpolation is Nearest instead Linear

# void nvgBeginFrame(NVGcontext* ctx, float windowWidth, float windowHeight, float devicePixelRatio);    /* original C++ signature */
def begin_frame(
    ctx: Context,
    window_width: float,
    window_height: float,
    device_pixel_ratio: float
    ) -> None:
    """ Begin drawing a new frame
     Calls to nanovg drawing API should be wrapped in nvgBeginFrame() & nvgEndFrame()
     nvgBeginFrame() defines the size of the window to render to in relation currently
     set viewport (i.e. glViewport on GL backends). Device pixel ration allows to
     control the rendering on Hi-DPI devices.
     For example, GLFW returns two dimension for an opened window: window size and
     frame buffer size. In that case you would set windowWidth/Height to the window size
     devicePixelRatio to: frameBufferWidth / windowWidth.
    """
    pass

# void nvgCancelFrame(NVGcontext* ctx);    /* original C++ signature */
def cancel_frame(ctx: Context) -> None:
    """ Cancels drawing the current frame."""
    pass

# void nvgEndFrame(NVGcontext* ctx);    /* original C++ signature */
def end_frame(ctx: Context) -> None:
    """ Ends drawing flushing remaining render state."""
    pass

#
# Composite operation
#
# The composite operations in NanoVG are modeled after HTML Canvas API, and
# the blend func is based on OpenGL (see corresponding manuals for more info).
# The colors in the blending state have premultiplied alpha.

# void nvgGlobalCompositeOperation(NVGcontext* ctx, int op);    /* original C++ signature */
def global_composite_operation(ctx: Context, op: int) -> None:
    """ Sets the composite operation. The op parameter should be one of NVGcompositeOperation."""
    pass

# void nvgGlobalCompositeBlendFunc(NVGcontext* ctx, int sfactor, int dfactor);    /* original C++ signature */
def global_composite_blend_func(ctx: Context, sfactor: int, dfactor: int) -> None:
    """ Sets the composite operation with custom pixel arithmetic. The parameters should be one of NVGblendFactor."""
    pass

# void nvgGlobalCompositeBlendFuncSeparate(NVGcontext* ctx, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha);    /* original C++ signature */
def global_composite_blend_func_separate(
    ctx: Context,
    src_rgb: int,
    dst_rgb: int,
    src_alpha: int,
    dst_alpha: int
    ) -> None:
    """ Sets the composite operation with custom pixel arithmetic for RGB and alpha components separately. The parameters should be one of NVGblendFactor."""
    pass

#
# Color utils
#
# Colors in NanoVG are stored as unsigned ints in ABGR format.

# NVGcolor nvgRGB(unsigned char r, unsigned char g, unsigned char b);    /* original C++ signature */
def rgb(r: UChar, g: UChar, b: UChar) -> Color:
    """ Returns a color value from red, green, blue values. Alpha will be set to 255 (1.0)."""
    pass

# NVGcolor nvgRGBf(float r, float g, float b);    /* original C++ signature */
def rgb_f(r: float, g: float, b: float) -> Color:
    """ Returns a color value from red, green, blue values. Alpha will be set to 1.0."""
    pass


# NVGcolor nvgRGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a);    /* original C++ signature */
def rgba(r: UChar, g: UChar, b: UChar, a: UChar) -> Color:
    """ Returns a color value from red, green, blue and alpha values."""
    pass

# NVGcolor nvgRGBAf(float r, float g, float b, float a);    /* original C++ signature */
def rgba_f(r: float, g: float, b: float, a: float) -> Color:
    """ Returns a color value from red, green, blue and alpha values."""
    pass


# NVGcolor nvgLerpRGBA(NVGcolor c0, NVGcolor c1, float u);    /* original C++ signature */
def lerp_rgba(c0: Color, c1: Color, u: float) -> Color:
    """ Linearly interpolates from color c0 to c1, and returns resulting color value."""
    pass

# NVGcolor nvgTransRGBA(NVGcolor c0, unsigned char a);    /* original C++ signature */
def trans_rgba(c0: Color, a: UChar) -> Color:
    """ Sets transparency of a color value."""
    pass

# NVGcolor nvgTransRGBAf(NVGcolor c0, float a);    /* original C++ signature */
def trans_rgb_af(c0: Color, a: float) -> Color:
    """ Sets transparency of a color value."""
    pass

# NVGcolor nvgHSL(float h, float s, float l);    /* original C++ signature */
def hsl(h: float, s: float, l: float) -> Color:
    """ Returns color value specified by hue, saturation and lightness.
     HSL values are all in range [0..1], alpha will be set to 255.
    """
    pass

# NVGcolor nvgHSLA(float h, float s, float l, unsigned char a);    /* original C++ signature */
def hsla(h: float, s: float, l: float, a: UChar) -> Color:
    """ Returns color value specified by hue, saturation and lightness and alpha.
     HSL values are all in range [0..1], alpha in range [0..255]
    """
    pass

#
# State Handling
#
# NanoVG contains state which represents how paths will be rendered.
# The state contains transform, fill and stroke styles, text and font styles,
# and scissor clipping.

# void nvgSave(NVGcontext* ctx);    /* original C++ signature */
def save(ctx: Context) -> None:
    """ Pushes and saves the current render state into a state stack.
     A matching nvgRestore() must be used to restore the state.
    """
    pass

# void nvgRestore(NVGcontext* ctx);    /* original C++ signature */
def restore(ctx: Context) -> None:
    """ Pops and restores current render state."""
    pass

# void nvgReset(NVGcontext* ctx);    /* original C++ signature */
def reset(ctx: Context) -> None:
    """ Resets current render state to default values. Does not affect the render state stack."""
    pass

#
# Render styles
#
# Fill and stroke render style can be either a solid color or a paint which is a gradient or a pattern.
# Solid color is simply defined as a color value, different kinds of paints can be created
# using nvgLinearGradient(), nvgBoxGradient(), nvgRadialGradient() and nvgImagePattern().
#
# Current render style can be saved and restored using nvgSave() and nvgRestore().

# void nvgShapeAntiAlias(NVGcontext* ctx, int enabled);    /* original C++ signature */
def shape_anti_alias(ctx: Context, enabled: int) -> None:
    """ Sets whether to draw antialias for nvgStroke() and nvgFill(). It's enabled by default."""
    pass

# void nvgStrokeColor(NVGcontext* ctx, NVGcolor color);    /* original C++ signature */
def stroke_color(ctx: Context, color: Color) -> None:
    """ Sets current stroke style to a solid color."""
    pass

# void nvgStrokePaint(NVGcontext* ctx, NVGpaint paint);    /* original C++ signature */
def stroke_paint(ctx: Context, paint: Paint) -> None:
    """ Sets current stroke style to a paint, which can be a one of the gradients or a pattern."""
    pass

# void nvgFillColor(NVGcontext* ctx, NVGcolor color);    /* original C++ signature */
def fill_color(ctx: Context, color: Color) -> None:
    """ Sets current fill style to a solid color."""
    pass

# void nvgFillPaint(NVGcontext* ctx, NVGpaint paint);    /* original C++ signature */
def fill_paint(ctx: Context, paint: Paint) -> None:
    """ Sets current fill style to a paint, which can be a one of the gradients or a pattern."""
    pass

# void nvgMiterLimit(NVGcontext* ctx, float limit);    /* original C++ signature */
def miter_limit(ctx: Context, limit: float) -> None:
    """ Sets the miter limit of the stroke style.
     Miter limit controls when a sharp corner is beveled.
    """
    pass

# void nvgStrokeWidth(NVGcontext* ctx, float size);    /* original C++ signature */
def stroke_width(ctx: Context, size: float) -> None:
    """ Sets the stroke width of the stroke style."""
    pass

# void nvgLineCap(NVGcontext* ctx, int cap);    /* original C++ signature */
def line_cap(ctx: Context, cap: int) -> None:
    """ Sets how the end of the line (cap) is drawn,
     Can be one of: NVG_BUTT (default), NVG_ROUND, NVG_SQUARE.
    """
    pass

# void nvgLineJoin(NVGcontext* ctx, int join);    /* original C++ signature */
def line_join(ctx: Context, join: int) -> None:
    """ Sets how sharp path corners are drawn.
     Can be one of NVG_MITER (default), NVG_ROUND, NVG_BEVEL.
    """
    pass

# void nvgGlobalAlpha(NVGcontext* ctx, float alpha);    /* original C++ signature */
def global_alpha(ctx: Context, alpha: float) -> None:
    """ Sets the transparency applied to all rendered shapes.
     Already transparent paths will get proportionally more transparent as well.
    """
    pass

#
# Transforms
#
# The paths, gradients, patterns and scissor region are transformed by an transformation
# matrix at the time when they are passed to the API.
# The current transformation matrix is a affine matrix:
#   [sx kx tx]
#   [ky sy ty]
#   [ 0  0  1]
# Where: sx,sy define scaling, kx,ky skewing, and tx,ty translation.
# The last row is assumed to be 0,0,1 and is not stored.
#
# Apart from nvgResetTransform(), each transformation function first creates
# specific transformation matrix and pre-multiplies the current transformation by it.
#
# Current coordinate system (transformation) can be saved and restored using nvgSave() and nvgRestore().

# void nvgResetTransform(NVGcontext* ctx);    /* original C++ signature */
def reset_transform(ctx: Context) -> None:
    """ Resets current transform to a identity matrix."""
    pass

# void nvgTransform(NVGcontext* ctx, float a, float b, float c, float d, float e, float f);    /* original C++ signature */
def transform(
    ctx: Context,
    a: float,
    b: float,
    c: float,
    d: float,
    e: float,
    f: float
    ) -> None:
    """ Premultiplies current coordinate system by specified matrix.
     The parameters are interpreted as matrix as follows:
       [a c e]
       [b d f]
       [0 0 1]
    """
    pass

# void nvgTranslate(NVGcontext* ctx, float x, float y);    /* original C++ signature */
def translate(ctx: Context, x: float, y: float) -> None:
    """ Translates current coordinate system."""
    pass

# void nvgRotate(NVGcontext* ctx, float angle);    /* original C++ signature */
def rotate(ctx: Context, angle: float) -> None:
    """ Rotates current coordinate system. Angle is specified in radians."""
    pass

# void nvgSkewX(NVGcontext* ctx, float angle);    /* original C++ signature */
def skew_x(ctx: Context, angle: float) -> None:
    """ Skews the current coordinate system along X axis. Angle is specified in radians."""
    pass

# void nvgSkewY(NVGcontext* ctx, float angle);    /* original C++ signature */
def skew_y(ctx: Context, angle: float) -> None:
    """ Skews the current coordinate system along Y axis. Angle is specified in radians."""
    pass

# void nvgScale(NVGcontext* ctx, float x, float y);    /* original C++ signature */
def scale(ctx: Context, x: float, y: float) -> None:
    """ Scales the current coordinate system."""
    pass

# void nvgCurrentTransform(NVGcontext* ctx, float* xform);    /* original C++ signature */
def current_transform(ctx: Context, xform: float) -> None:
    """ Stores the top part (a-f) of the current transformation matrix in to the specified buffer.
       [a c e]
       [b d f]
       [0 0 1]
     There should be space for 6 floats in the return buffer for the values a-f.
    """
    pass


# The following functions can be used to make calculations on 2x3 transformation matrices.
# A 2x3 matrix is represented as float[6].

# void nvgTransformIdentity(float* dst);    /* original C++ signature */
def transform_identity(dst: float) -> None:
    """ Sets the transform to identity matrix."""
    pass

# void nvgTransformTranslate(float* dst, float tx, float ty);    /* original C++ signature */
def transform_translate(dst: float, tx: float, ty: float) -> None:
    """ Sets the transform to translation matrix matrix."""
    pass

# void nvgTransformScale(float* dst, float sx, float sy);    /* original C++ signature */
def transform_scale(dst: float, sx: float, sy: float) -> None:
    """ Sets the transform to scale matrix."""
    pass

# void nvgTransformRotate(float* dst, float a);    /* original C++ signature */
def transform_rotate(dst: float, a: float) -> None:
    """ Sets the transform to rotate matrix. Angle is specified in radians."""
    pass

# void nvgTransformSkewX(float* dst, float a);    /* original C++ signature */
def transform_skew_x(dst: float, a: float) -> None:
    """ Sets the transform to skew-x matrix. Angle is specified in radians."""
    pass

# void nvgTransformSkewY(float* dst, float a);    /* original C++ signature */
def transform_skew_y(dst: float, a: float) -> None:
    """ Sets the transform to skew-y matrix. Angle is specified in radians."""
    pass

# void nvgTransformMultiply(float* dst, const float* src);    /* original C++ signature */
def transform_multiply(dst: float, src: float) -> None:
    """ Sets the transform to the result of multiplication of two transforms, of A = A*B."""
    pass

# void nvgTransformPremultiply(float* dst, const float* src);    /* original C++ signature */
def transform_premultiply(dst: float, src: float) -> None:
    """ Sets the transform to the result of multiplication of two transforms, of A = B*A."""
    pass

# int nvgTransformInverse(float* dst, const float* src);    /* original C++ signature */
def transform_inverse(dst: float, src: float) -> int:
    """ Sets the destination to inverse of specified transform.
     Returns 1 if the inverse could be calculated, else 0.
    """
    pass

# void nvgTransformPoint(float* dstx, float* dsty, const float* xform, float srcx, float srcy);    /* original C++ signature */
def transform_point(
    dstx: float,
    dsty: float,
    xform: float,
    srcx: float,
    srcy: float
    ) -> None:
    """ Transform a point by given transform."""
    pass

# Converts degrees to radians and vice versa.
# float nvgDegToRad(float deg);    /* original C++ signature */
def deg_to_rad(deg: float) -> float:
    pass
# float nvgRadToDeg(float rad);    /* original C++ signature */
def rad_to_deg(rad: float) -> float:
    pass

#
# Images
#
# NanoVG allows you to load jpg, png, psd, tga, pic and gif files to be used for rendering.
# In addition you can upload your own image. The image loading is provided by stb_image.
# The parameter imageFlags is combination of flags defined in NVGimageFlags.

# int nvgCreateImage(NVGcontext* ctx, const char* filename, int imageFlags);    /* original C++ signature */
def create_image(ctx: Context, filename: str, image_flags: int) -> int:
    """ Creates image by loading it from the disk from specified file name.
     Returns handle to the image.
    """
    pass

# int nvgCreateImageMem(NVGcontext* ctx, int imageFlags, unsigned char* data, int ndata);    /* original C++ signature */
def create_image_mem(ctx: Context, image_flags: int, data: UChar, ndata: int) -> int:
    """ Creates image by loading it from the specified chunk of memory.
     Returns handle to the image.
    """
    pass

# int nvgCreateImageRGBA(NVGcontext* ctx, int w, int h, int imageFlags, const unsigned char* data);    /* original C++ signature */
def create_image_rgba(
    ctx: Context,
    w: int,
    h: int,
    image_flags: int,
    data: UChar
    ) -> int:
    """ Creates image from specified image data.
     Returns handle to the image.
    """
    pass

# void nvgUpdateImage(NVGcontext* ctx, int image, const unsigned char* data);    /* original C++ signature */
def update_image(ctx: Context, image: int, data: UChar) -> None:
    """ Updates image data specified by image handle."""
    pass


# void nvgDeleteImage(NVGcontext* ctx, int image);    /* original C++ signature */
def delete_image(ctx: Context, image: int) -> None:
    """ Deletes created image."""
    pass

#
# Paints
#
# NanoVG supports four types of paints: linear gradient, box gradient, radial gradient and image pattern.
# These can be used as paints for strokes and fills.

# NVGpaint nvgLinearGradient(NVGcontext* ctx, float sx, float sy, float ex, float ey,    /* original C++ signature */
# 						   NVGcolor icol, NVGcolor ocol);
def linear_gradient(
    ctx: Context,
    sx: float,
    sy: float,
    ex: float,
    ey: float,
    icol: Color,
    ocol: Color
    ) -> Paint:
    """ Creates and returns a linear gradient. Parameters (sx,sy)-(ex,ey) specify the start and end coordinates
     of the linear gradient, icol specifies the start color and ocol the end color.
     The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().
    """
    pass

# NVGpaint nvgBoxGradient(NVGcontext* ctx, float x, float y, float w, float h,    /* original C++ signature */
# 						float r, float f, NVGcolor icol, NVGcolor ocol);
def box_gradient(
    ctx: Context,
    x: float,
    y: float,
    w: float,
    h: float,
    r: float,
    f: float,
    icol: Color,
    ocol: Color
    ) -> Paint:
    """ Creates and returns a box gradient. Box gradient is a feathered rounded rectangle, it is useful for rendering
     drop shadows or highlights for boxes. Parameters (x,y) define the top-left corner of the rectangle,
     (w,h) define the size of the rectangle, r defines the corner radius, and f feather. Feather defines how blurry
     the border of the rectangle is. Parameter icol specifies the inner color and ocol the outer color of the gradient.
     The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().
    """
    pass

# NVGpaint nvgRadialGradient(NVGcontext* ctx, float cx, float cy, float inr, float outr,    /* original C++ signature */
# 						   NVGcolor icol, NVGcolor ocol);
def radial_gradient(
    ctx: Context,
    cx: float,
    cy: float,
    inr: float,
    outr: float,
    icol: Color,
    ocol: Color
    ) -> Paint:
    """ Creates and returns a radial gradient. Parameters (cx,cy) specify the center, inr and outr specify
     the inner and outer radius of the gradient, icol specifies the start color and ocol the end color.
     The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().
    """
    pass

# NVGpaint nvgImagePattern(NVGcontext* ctx, float ox, float oy, float ex, float ey,    /* original C++ signature */
# 						 float angle, int image, float alpha);
def image_pattern(
    ctx: Context,
    ox: float,
    oy: float,
    ex: float,
    ey: float,
    angle: float,
    image: int,
    alpha: float
    ) -> Paint:
    """ Creates and returns an image pattern. Parameters (ox,oy) specify the left-top location of the image pattern,
     (ex,ey) the size of one image, angle rotation around the top-left corner, image is handle to the image to render.
     The gradient is transformed by the current transform when it is passed to nvgFillPaint() or nvgStrokePaint().
    """
    pass

#
# Scissoring
#
# Scissoring allows you to clip the rendering into a rectangle. This is useful for various
# user interface cases like rendering a text edit or a timeline.

# void nvgScissor(NVGcontext* ctx, float x, float y, float w, float h);    /* original C++ signature */
def scissor(ctx: Context, x: float, y: float, w: float, h: float) -> None:
    """ Sets the current scissor rectangle.
     The scissor rectangle is transformed by the current transform.
    """
    pass

# void nvgIntersectScissor(NVGcontext* ctx, float x, float y, float w, float h);    /* original C++ signature */
def intersect_scissor(ctx: Context, x: float, y: float, w: float, h: float) -> None:
    """ Intersects current scissor rectangle with the specified rectangle.
     The scissor rectangle is transformed by the current transform.
     Note: in case the rotation of previous scissor rect differs from
     the current one, the intersection will be done between the specified
     rectangle and the previous scissor rectangle transformed in the current
     transform space. The resulting shape is always rectangle.
    """
    pass

# void nvgResetScissor(NVGcontext* ctx);    /* original C++ signature */
def reset_scissor(ctx: Context) -> None:
    """ Reset and disables scissoring."""
    pass

#
# Paths
#
# Drawing a new shape starts with nvgBeginPath(), it clears all the currently defined paths.
# Then you define one or more paths and sub-paths which describe the shape. The are functions
# to draw common shapes like rectangles and circles, and lower level step-by-step functions,
# which allow to define a path curve by curve.
#
# NanoVG uses even-odd fill rule to draw the shapes. Solid shapes should have counter clockwise
# winding and holes should have counter clockwise order. To specify winding of a path you can
# call nvgPathWinding(). This is useful especially for the common shapes, which are drawn CCW.
#
# Finally you can fill the path using current fill style by calling nvgFill(), and stroke it
# with current stroke style by calling nvgStroke().
#
# The curve segments and sub-paths are transformed by the current transform.

# void nvgBeginPath(NVGcontext* ctx);    /* original C++ signature */
def begin_path(ctx: Context) -> None:
    """ Clears the current path and sub-paths."""
    pass

# void nvgMoveTo(NVGcontext* ctx, float x, float y);    /* original C++ signature */
def move_to(ctx: Context, x: float, y: float) -> None:
    """ Starts new sub-path with specified point as first point."""
    pass

# void nvgLineTo(NVGcontext* ctx, float x, float y);    /* original C++ signature */
def line_to(ctx: Context, x: float, y: float) -> None:
    """ Adds line segment from the last point in the path to the specified point."""
    pass

# void nvgBezierTo(NVGcontext* ctx, float c1x, float c1y, float c2x, float c2y, float x, float y);    /* original C++ signature */
def bezier_to(
    ctx: Context,
    c1x: float,
    c1y: float,
    c2x: float,
    c2y: float,
    x: float,
    y: float
    ) -> None:
    """ Adds cubic bezier segment from last point in the path via two control points to the specified point."""
    pass

# void nvgQuadTo(NVGcontext* ctx, float cx, float cy, float x, float y);    /* original C++ signature */
def quad_to(ctx: Context, cx: float, cy: float, x: float, y: float) -> None:
    """ Adds quadratic bezier segment from last point in the path via a control point to the specified point."""
    pass

# void nvgArcTo(NVGcontext* ctx, float x1, float y1, float x2, float y2, float radius);    /* original C++ signature */
def arc_to(
    ctx: Context,
    x1: float,
    y1: float,
    x2: float,
    y2: float,
    radius: float
    ) -> None:
    """ Adds an arc segment at the corner defined by the last path point, and two specified points."""
    pass

# void nvgClosePath(NVGcontext* ctx);    /* original C++ signature */
def close_path(ctx: Context) -> None:
    """ Closes current sub-path with a line segment."""
    pass

# void nvgPathWinding(NVGcontext* ctx, int dir);    /* original C++ signature */
def path_winding(ctx: Context, dir: int) -> None:
    """ Sets the current sub-path winding, see NVGwinding and NVGsolidity."""
    pass

# void nvgArc(NVGcontext* ctx, float cx, float cy, float r, float a0, float a1, int dir);    /* original C++ signature */
def arc(
    ctx: Context,
    cx: float,
    cy: float,
    r: float,
    a0: float,
    a1: float,
    dir: int
    ) -> None:
    """ Creates new circle arc shaped sub-path. The arc center is at cx,cy, the arc radius is r,
     and the arc is drawn from angle a0 to a1, and swept in direction dir (NVG_CCW, or NVG_CW).
     Angles are specified in radians.
    """
    pass

# void nvgRect(NVGcontext* ctx, float x, float y, float w, float h);    /* original C++ signature */
def rect(ctx: Context, x: float, y: float, w: float, h: float) -> None:
    """ Creates new rectangle shaped sub-path."""
    pass

# void nvgRoundedRect(NVGcontext* ctx, float x, float y, float w, float h, float r);    /* original C++ signature */
def rounded_rect(
    ctx: Context,
    x: float,
    y: float,
    w: float,
    h: float,
    r: float
    ) -> None:
    """ Creates new rounded rectangle shaped sub-path."""
    pass

# void nvgRoundedRectVarying(NVGcontext* ctx, float x, float y, float w, float h, float radTopLeft, float radTopRight, float radBottomRight, float radBottomLeft);    /* original C++ signature */
def rounded_rect_varying(
    ctx: Context,
    x: float,
    y: float,
    w: float,
    h: float,
    rad_top_left: float,
    rad_top_right: float,
    rad_bottom_right: float,
    rad_bottom_left: float
    ) -> None:
    """ Creates new rounded rectangle shaped sub-path with varying radii for each corner."""
    pass

# void nvgEllipse(NVGcontext* ctx, float cx, float cy, float rx, float ry);    /* original C++ signature */
def ellipse(ctx: Context, cx: float, cy: float, rx: float, ry: float) -> None:
    """ Creates new ellipse shaped sub-path."""
    pass

# void nvgCircle(NVGcontext* ctx, float cx, float cy, float r);    /* original C++ signature */
def circle(ctx: Context, cx: float, cy: float, r: float) -> None:
    """ Creates new circle shaped sub-path."""
    pass

# void nvgFill(NVGcontext* ctx);    /* original C++ signature */
def fill(ctx: Context) -> None:
    """ Fills the current path with current fill style."""
    pass

# void nvgStroke(NVGcontext* ctx);    /* original C++ signature */
def stroke(ctx: Context) -> None:
    """ Fills the current path with current stroke style."""
    pass


#
# Text
#
# NanoVG allows you to load .ttf files and use the font to render text.
#
# The appearance of the text can be defined by setting the current text style
# and by specifying the fill color. Common text and font settings such as
# font size, letter spacing and text align are supported. Font blur allows you
# to create simple text effects such as drop shadows.
#
# At render time the font face can be set based on the font handles or name.
#
# Font measure functions return values in local space, the calculations are
# carried in the same resolution as the final rendering. This is done because
# the text glyph positions are snapped to the nearest pixels sharp rendering.
#
# The local space means that values are not rotated or scale as per the current
# transformation. For example if you set font size to 12, which would mean that
# line height is 16, then regardless of the current scaling and rotation, the
# returned line height is always 16. Some measures may vary because of the scaling
# since aforementioned pixel snapping.
#
# While this may sound a little odd, the setup allows you to always render the
# same way regardless of scaling. I.e. following works regardless of scaling:
#
#		const char* txt = "Text me up.";
#		nvgTextBounds(vg, x,y, txt, None, bounds);
#		nvgBeginPath(vg);
#		nvgRect(vg, bounds[0],bounds[1], bounds[2]-bounds[0], bounds[3]-bounds[1]);
#		nvgFill(vg);
#
# Note: currently only solid color fill is supported for text.

# int nvgCreateFont(NVGcontext* ctx, const char* name, const char* filename);    /* original C++ signature */
def create_font(ctx: Context, name: str, filename: str) -> int:
    """ Creates font by loading it from the disk from specified file name.
     Returns handle to the font.
    """
    pass

# int nvgCreateFontAtIndex(NVGcontext* ctx, const char* name, const char* filename, const int fontIndex);    /* original C++ signature */
def create_font_at_index(
    ctx: Context,
    name: str,
    filename: str,
    font_index: int
    ) -> int:
    """ fontIndex specifies which font face to load from a .ttf/.ttc file."""
    pass

# int nvgCreateFontMem(NVGcontext* ctx, const char* name, unsigned char* data, int ndata, int freeData);    /* original C++ signature */
def create_font_mem(
    ctx: Context,
    name: str,
    data: UChar,
    ndata: int,
    free_data: int
    ) -> int:
    """ Creates font by loading it from the specified memory chunk.
     Returns handle to the font.
    """
    pass

# int nvgCreateFontMemAtIndex(NVGcontext* ctx, const char* name, unsigned char* data, int ndata, int freeData, const int fontIndex);    /* original C++ signature */
def create_font_mem_at_index(
    ctx: Context,
    name: str,
    data: UChar,
    ndata: int,
    free_data: int,
    font_index: int
    ) -> int:
    """ fontIndex specifies which font face to load from a .ttf/.ttc file."""
    pass

# int nvgFindFont(NVGcontext* ctx, const char* name);    /* original C++ signature */
def find_font(ctx: Context, name: str) -> int:
    """ Finds a loaded font of specified name, and returns handle to it, or -1 if the font is not found."""
    pass

# int nvgAddFallbackFontId(NVGcontext* ctx, int baseFont, int fallbackFont);    /* original C++ signature */
def add_fallback_font_id(ctx: Context, base_font: int, fallback_font: int) -> int:
    """ Adds a fallback font by handle."""
    pass

# int nvgAddFallbackFont(NVGcontext* ctx, const char* baseFont, const char* fallbackFont);    /* original C++ signature */
def add_fallback_font(ctx: Context, base_font: str, fallback_font: str) -> int:
    """ Adds a fallback font by name."""
    pass

# void nvgResetFallbackFontsId(NVGcontext* ctx, int baseFont);    /* original C++ signature */
def reset_fallback_fonts_id(ctx: Context, base_font: int) -> None:
    """ Resets fallback fonts by handle."""
    pass

# void nvgResetFallbackFonts(NVGcontext* ctx, const char* baseFont);    /* original C++ signature */
def reset_fallback_fonts(ctx: Context, base_font: str) -> None:
    """ Resets fallback fonts by name."""
    pass

# void nvgFontSize(NVGcontext* ctx, float size);    /* original C++ signature */
def font_size(ctx: Context, size: float) -> None:
    """ Sets the font size of current text style."""
    pass

# void nvgFontBlur(NVGcontext* ctx, float blur);    /* original C++ signature */
def font_blur(ctx: Context, blur: float) -> None:
    """ Sets the blur of current text style."""
    pass




# void nvgFontFaceId(NVGcontext* ctx, int font);    /* original C++ signature */
def font_face_id(ctx: Context, font: int) -> None:
    """ Sets the font face based on specified id of current text style."""
    pass

# void nvgFontFace(NVGcontext* ctx, const char* font);    /* original C++ signature */
def font_face(ctx: Context, font: str) -> None:
    """ Sets the font face based on specified name of current text style."""
    pass








class Texture(enum.Enum):
    """
     Internal Render API

    """
    # NVG_TEXTURE_ALPHA = 0x01,    /* original C++ signature */
    texture_alpha = enum.auto() # (= 0x01)
    # NVG_TEXTURE_RGBA = 0x02,    /* original C++ signature */
    # }
    texture_rgba = enum.auto()  # (= 0x02)

class Scissor:
    # float xform[6];    /* original C++ signature */
    xform: np.ndarray   # ndarray[type=float, size=6]
    # float extent[2];    /* original C++ signature */
    extent: np.ndarray  # ndarray[type=float, size=2]
    # NVGscissor();    /* original C++ signature */
    def __init__(self) -> None:
        """Auto-generated default constructor"""
        pass

class Vertex:
    # float x,    /* original C++ signature */
    x: float
    # y,    /* original C++ signature */
    y: float
    # u,    /* original C++ signature */
    u: float
    # v;    /* original C++ signature */
    v: float
    # NVGvertex(float x = float(), float y = float(), float u = float(), float v = float());    /* original C++ signature */
    def __init__(
        self,
        x: float = float(),
        y: float = float(),
        u: float = float(),
        v: float = float()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class Path:
    # int first;    /* original C++ signature */
    first: int
    # int count;    /* original C++ signature */
    count: int
    # unsigned char closed;    /* original C++ signature */
    closed: UChar
    # int nbevel;    /* original C++ signature */
    nbevel: int
    # NVGvertex* fill;    /* original C++ signature */
    fill: Vertex
    # int nfill;    /* original C++ signature */
    nfill: int
    # NVGvertex* stroke;    /* original C++ signature */
    stroke: Vertex
    # int nstroke;    /* original C++ signature */
    nstroke: int
    # int winding;    /* original C++ signature */
    winding: int
    # int convex;    /* original C++ signature */
    convex: int
    # NVGpath(int first = int(), int count = int(), int nbevel = int(), int nfill = int(), int nstroke = int(), int winding = int(), int convex = int());    /* original C++ signature */
    def __init__(
        self,
        first: int = int(),
        count: int = int(),
        nbevel: int = int(),
        nfill: int = int(),
        nstroke: int = int(),
        winding: int = int(),
        convex: int = int()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class Params:
    # void* userPtr;    /* original C++ signature */
    user_ptr: Any
    # int edgeAntiAlias;    /* original C++ signature */
    edge_anti_alias: int
    # NVGparams(int edgeAntiAlias = int());    /* original C++ signature */
    def __init__(self, edge_anti_alias: int = int()) -> None:
        """Auto-generated default constructor with named params"""
        pass

# Constructor and destructor, called by the render back-end.
# NVGcontext* nvgCreateInternal(NVGparams* params);    /* original C++ signature */
def create_internal(params: Params) -> Context:
    pass
# void nvgDeleteInternal(NVGcontext* ctx);    /* original C++ signature */
def delete_internal(ctx: Context) -> None:
    pass

# NVGparams* nvgInternalParams(NVGcontext* ctx);    /* original C++ signature */
def internal_params(ctx: Context) -> Params:
    pass

# void nvgDebugDumpPathCache(NVGcontext* ctx);    /* original C++ signature */
def debug_dump_path_cache(ctx: Context) -> None:
    """ Debug function to dump cached path data."""
    pass



# #ifdef __cplusplus
#
# #endif
#

# #endif
####################    </generated_from:nanovg.h>    ####################


####################    <generated_from:nvg_imgui.h>    ####################
# #ifdef IMGUI_BUNDLE_WITH_NANOVG
#






# #endif

# <submodule nvg_imgui>
class nvg_imgui:  # Proxy class that introduces typings for the *submodule* nvg_imgui
    pass  # (This corresponds to a C++ namespace. All method are static!)

    #/////////////////////////////////////////////////////////////////////////
    #
    #           NanoVG context creation/deletion
    #
    #///////////////////////////////////////////////////////////////////////

    class NvgCreateFlags(enum.Enum):
        """ Combination of NVGcreateFlags in nanovg_gl.h + nanovg_mtl.h"""
        # NVG_ANTIALIAS 		= 1<<0,    /* original C++ signature */
        # Flag indicating if geometry based antialiasing is used (may not be needed when using MSAA).
        antialias = enum.auto()       # (= 1<<0)
        # NVG_STENCIL_STROKES	= 1<<1,    /* original C++ signature */
        # Flag indicating if strokes should be drawn using stencil buffer. The rendering will be a little
        # slower, but path overlaps (i.e. self-intersecting or sharp turns) will be drawn just once.
        stencil_strokes = enum.auto() # (= 1<<1)
        # NVG_DEBUG 			= 1<<2,    /* original C++ signature */
        # Flag indicating that additional debug checks are done.
        debug = enum.auto()           # (= 1<<2)

        # NVG_DOUBLE_BUFFER = 1 << 12,    /* original C++ signature */
        # Flag indicating if double buffering scheme is used (Metal only!)
        double_buffer = enum.auto()   # (= 1 << 12)
        # NVG_TRIPLE_BUFFER = 1 << 13,    /* original C++ signature */
        #     }
        # Flag indicating if triple buffering scheme is used (Metal only!)
        triple_buffer = enum.auto()   # (= 1 << 13)


    # If using HelloImGui, you can use this function to create a NanoVG context
    # (it will select the correct function depending on the rendering backend)
    # NVGcontext* CreateNvgContext_HelloImGui(int flags = 0);    /* original C++ signature */
    @staticmethod
    def create_nvg_context_hello_imgui(flags: int = 0) -> Context:
        pass
    # void DeleteNvgContext_HelloImGui(NVGcontext* vg);    /* original C++ signature */
    @staticmethod
    def delete_nvg_context_hello_imgui(vg: Context) -> None:
        pass


    #/////////////////////////////////////////////////////////////////////////
    #
    #           NanoVG framebuffer
    #
    #///////////////////////////////////////////////////////////////////////

    class NvgFramebuffer:
        """ NvgFramebuffer: a framebuffer that can be used by NanoVG + ImGui
         Internally stored inside the renderer backend (e.g. OpenGL)
         Note: this class can be instantiated only after a valid renderer backend (OpenGL) has been created
        """
        # NVGcontext *vg = nullptr;    /* original C++ signature */
        vg: Context = None
        # int Width = 0,     /* original C++ signature */
        width: int = 0
        # Height = 0;    /* original C++ signature */
        height: int = 0
        # int NvgImageFlags = 0;    /* original C++ signature */
        nvg_image_flags: int = 0
        # ImTextureID TextureId = {};    /* original C++ signature */
        texture_id: ImTextureID = ImTextureID()

        # Warning: this constructor can be called only after a valid renderer backend (OpenGL) has been created
        # (will call Init())
        # NvgFramebuffer(    /* original C++ signature */
        #             NVGcontext *vg,
        #             int width, int height,
        #             int nvgImageFlags
        #             );
        def __init__(self, vg: Context, width: int, height: int, nvg_image_flags: int) -> None:
            """ See NVGimageFlags"""
            pass


        # void Bind();    /* original C++ signature */
        def bind(self) -> None:
            """ Make the framebuffer the current render target"""
            pass

        # void Unbind();    /* original C++ signature */
        def unbind(self) -> None:
            """ Restore the previous render target"""
            pass



    #/////////////////////////////////////////////////////////////////////////
    #
    #                 NanoVG rendering utilities
    #   (render NanoVG to either ImGui background or to a framebuffer)
    #
    #///////////////////////////////////////////////////////////////////////


    # void RenderNvgToBackground(    /* original C++ signature */
    #         NVGcontext* vg,
    #         NvgDrawingFunction nvgDrawingFunction,
    #         ImVec4 clearColor = ImVec4(0.f, 0.f, 0.f, 1.f)
    #         );
    @staticmethod
    def render_nvg_to_background(
        vg: Context,
        nvg_drawing_function: NvgDrawingFunction,
        clear_color: Optional[ImVec4Like] = None
        ) -> None:
        """ Render the given drawing function to the background of the application
         (i.e. the main viewport)
         If clearColor.w > 0., the background will be cleared with this color
        ---
        Python bindings defaults:
            If clearColor is None, then its default value will be: ImVec4(0., 0., 0., 1.)
        """
        pass

    # void RenderNvgToFrameBuffer(    /* original C++ signature */
    #         NVGcontext* vg,
    #         NvgFramebuffer& texture,
    #         NvgDrawingFunction drawFunc,
    #         ImVec4 clearColor = ImVec4(0.f, 0.f, 0.f, 1.f)
    #         );
    @staticmethod
    def render_nvg_to_frame_buffer(
        vg: Context,
        texture: NvgFramebuffer,
        draw_func: NvgDrawingFunction,
        clear_color: Optional[ImVec4Like] = None
        ) -> None:
        """ Render the given drawing function to the given framebuffer
         If clearColor.w > 0., the background will be cleared with this color
        ---
        Python bindings defaults:
            If clearColor is None, then its default value will be: ImVec4(0., 0., 0., 1.)
        """
        pass


# </submodule nvg_imgui>
####################    </generated_from:nvg_imgui.h>    ####################


####################    <generated_from:nvg_cpp_text.h>    ####################



# C++ Wrappers to NanoVG text functions, to simplify python bindings

# float nvgcpp_Text(NVGcontext* ctx, float x, float y, const std::string& text);    /* original C++ signature */
def text(ctx: Context, x: float, y: float, text: str) -> float:
    """ Draws text string at specified location. If end is specified only the sub-string up to the end is drawn."""
    pass

# void nvgcpp_TextBox(NVGcontext* ctx, float x, float y, float breakRowWidth, const std::string& text);    /* original C++ signature */
def text_box(
    ctx: Context,
    x: float,
    y: float,
    break_row_width: float,
    text: str
    ) -> None:
    """ Draws multi-line text string at specified location wrapped at the specified width. If end is specified only the sub-string up to the end is drawn.
     White space is stripped at the beginning of the rows, the text is split at word boundaries or when new-line characters are encountered.
     Words longer than the max width are split at nearest character (i.e. no hyphenation).
    """
    pass



# std::tuple<Bounds, float> nvgcpp_TextBounds(NVGcontext* ctx, float x, float y, const std::string& text);    /* original C++ signature */
def text_bounds(ctx: Context, x: float, y: float, text: str) -> Tuple[Bounds, float]:
    """ Measures the specified text string. Parameter bounds should be a pointer to float[4],
     if the bounding box of the text should be returned. The bounds value are [xmin,ymin, xmax,ymax]
     Returns the bounds + the horizontal advance of the measured text (i.e. where the next character should drawn)
     Measured values are returned in local coordinate space.
    """
    pass

# Bounds nvgcpp_TextBoxBounds(NVGcontext* ctx, float x, float y, float breakRowWidth, const std::string& text);    /* original C++ signature */
def text_box_bounds(
    ctx: Context,
    x: float,
    y: float,
    break_row_width: float,
    text: str
    ) -> Bounds:
    """ Measures the specified multi-text string. Parameter bounds should be a pointer to float[4],
     if the bounding box of the text should be returned. The bounds value are [xmin,ymin, xmax,ymax]
     Measured values are returned in local coordinate space.
    """
    pass

# std::vector<NVGglyphPosition> nvgcpp_TextGlyphPositions(NVGcontext* ctx, float x, float y, const std::string& text);    /* original C++ signature */
def text_glyph_positions(
    ctx: Context,
    x: float,
    y: float,
    text: str
    ) -> List[GlyphPosition]:
    """ Calculates the glyph x positions of the specified text. If end is specified only the sub-string will be used.
     Measured values are returned in local coordinate space.
    """
    pass


class TextMetricsData:
    # float ascender;    /* original C++ signature */
    ascender: float
    # float descender;    /* original C++ signature */
    descender: float
    # float lineh;    /* original C++ signature */
    lineh: float
    # TextMetricsData(float ascender = float(), float descender = float(), float lineh = float());    /* original C++ signature */
    def __init__(
        self,
        ascender: float = float(),
        descender: float = float(),
        lineh: float = float()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass

# TextMetricsData nvgcpp_TextMetrics(NVGcontext* ctx);    /* original C++ signature */
def text_metrics(ctx: Context) -> TextMetricsData:
    """ Returns the vertical metrics based on the current text style.
     Measured values are returned in local coordinate space.
    """
    pass


class TextRowSimple:
    # std::string row_text;    /* original C++ signature */
    row_text: str
    # float width;    /* original C++ signature */
    width: float  # Logical width of the row.
    # float minx,     /* original C++ signature */
    minx: float   # Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.
    # maxx;    /* original C++ signature */
    maxx: float   # Actual bounds of the row. Logical with and bounds can differ because of kerning and some parts over extending.
    # NVGtextRowSimple(std::string row_text = std::string(), float width = float(), float minx = float(), float maxx = float());    /* original C++ signature */
    def __init__(
        self,
        row_text: str = "",
        width: float = float(),
        minx: float = float(),
        maxx: float = float()
        ) -> None:
        """Auto-generated default constructor with named params"""
        pass


# std::vector<NVGtextRowSimple> nvgcpp_TextBreakLines(NVGcontext* ctx, const std::string& text, float breakRowWidth);    /* original C++ signature */
def text_break_lines(
    ctx: Context,
    text: str,
    break_row_width: float
    ) -> List[TextRowSimple]:
    """ Breaks the specified text into lines. If end is specified only the sub-string will be used.
     White space is stripped at the beginning of the rows, the text is split at word boundaries or when new-line characters are encountered.
     Words longer than the max width are split at nearest character (i.e. no hyphenation).
    """
    pass

# void nvgcpp_TextAlign(NVGcontext* ctx, int align);    /* original C++ signature */
def text_align(ctx: Context, align: int) -> None:
    """ Sets the text align of current text style, see NVGalign for options."""
    pass

# void nvgcpp_TextLineHeight(NVGcontext* ctx, float lineHeight);    /* original C++ signature */
def text_line_height(ctx: Context, line_height: float) -> None:
    """ Sets the proportional line height of current text style. The line height is specified as multiple of font size."""
    pass


# std::tuple<int, int> nvgcpp_ImageSize(NVGcontext* ctx, int image);    /* original C++ signature */
def image_size(ctx: Context, image: int) -> Tuple[int, int]:
    """ Returns the dimensions of a created image."""
    pass
####################    </generated_from:nvg_cpp_text.h>    ####################

# </litgen_stub> // Autogenerated code end!
